add_portrait("Tutorial", "tutorial_portrait.png", 0);
add_portrait("Moravator Captain", "captain.png", 0);
add_portrait("Morellian Fighter Pilot", "commander.png", 0);
add_portrait("Freighter Captain", "windstille_worker.png", 1);

toggle_display_all_groups();
wait(30);

set_portrait("Moravator Captain");
portrait_text("Admiral, we've reached sector DF-342-364.", "wevereached.ogg");
wait_for_portrait();

portrait_text("This should be easy - destroying a convoy of unescorted freighters.", "this_should.ogg");
wait_for_portrait();

wait(30);

set_portrait("Tutorial");
portrait_text("Before you are the capital ships and frigates of your fleet, slow moving yet immensely resilient vessels. <Note that you can skip messages by pressing the enter key, and that there is an icon at the bottom of the screen to repeat earlier messages>", "1.ogg");
wait_for_portrait();

portrait_text("Contained within the hangar bays of the capital ships are the fast moving small ships - the fighters and bombers - with which most combat is conducted.", "2.ogg");
wait_for_portrait();

portrait_text("The frigates do not contain any small ships, but they do have a variety of powerful short-range armaments. They can be used to defend your capital ships from enemy torpedo bomber attacks, or to launch a direct assault on enemy capital ships.", "the_smaller.ogg");
wait_for_portrait();

portrait_text("Small ships can only fly for a limited amount of time before they need to return home to their hangar bay to refuel. You therefore first need to order your capital ships to move closer to the area where we believe the Artilian convoy to be.", "3.ogg");
wait_for_portrait();

while (true) {
	portrait_text("Select all of your capital ships and frigates at once by left clicking, holding down the mouse button, and dragging a box around them. If you fail to catch them all in a single box, hold down the shift key and then left click the remaining ships to add them to your selection. There are also hot keys to select all of your big ships (,), capital ships (.) or frigates (/).", "4.ogg");
	wait_for_task("all_big_selected", 250);
	if (wakeup_reason() == "all_big_selected")
		break;
}

portrait_text("Well done.", "5.ogg");
wait_for_portrait();

portrait_text("Note that if you select a ship, two horizontal bars appear. The upper green bar is a unit's shield, which gradually recharges over time when a unit is not taking damage. The lower blue bar is the unit's armour. A unit's armour can only be damaged if its shield is down, but once a ship's armour is gone it will be destroyed. Small ships will slowly repair their armour whilst they are in their hangar.", "note_that.ogg");
wait_for_portrait();

wait(30);

set_portrait("Moravator Captain");
portrait_text("Admiral, the presumed location and course of the freighters are displayed using the information we gained from the intercepted transmission. You will not normally be able to see enemy ships at such a long range. May I suggest we order the fleet to move to intercept?", "8.ogg");
wait_for_portrait();

wait(30);

set_portrait("Tutorial");
portrait_text("You can move the view by moving the cursor to the edge of the screen, by pressing a cursor key, or otherwise by clicking on the sensor area display at the bottom left hand corner of the screen.", "9.ogg");
wait_for_portrait();

portrait_text("Notice that if you move the view a large distance away from you ships then the display is darkened. Anything in this darkened area is outside of your ships' scanning range, and will normally be hidden from view.", "10.ogg");
wait_for_portrait();

while (true) {
	portrait_text("Right click at a point in space to order yours ships to move to intercept the freighters.", "11.ogg");
	wait_for_task("ships_moving_down", 250);
	if (wakeup_reason() == "ships_moving_down")
		break;
}

while (true) {
	portrait_text("You should launch a reconnaissance mission to ensure the information from the intercepted transmission is correct. If you hover the mouse cursor over one of the blue icons at the bottom of your screen, some white text will appear to explain what the icon does. Find the \"Missions\" icon, and click it (or alternatively press the W key).", "searching_the.ogg");
	wait_for_task("missions_open", 250);
	if (wakeup_reason() == "missions_open")
		break;
}

set_portrait("Tutorial", true);
while (true) {
	portrait_text("You are now presented with a list of all your ships. Along the top row of the list are your capital ships. The squadrons of fighters and bombers are currently in their hangars in their parent capital ships. Use the left mouse button to highlight two fighter squadrons. If you accidently highlight any other ships too, click the left mouse button on them again to unhighlight them.", "you_are_now.ogg");
	wait_for_task("two_fighter_squadrons_selected", 250);
	if (wakeup_reason() == "two_fighter_squadrons_selected")
		break;
}

while (true) {
	portrait_text("Click the \"Reconnaissance mission\" button at the bottom of your screen (or alternatively press the A key).", "click_the_recon.ogg");
	wait_for_task("recon_target_open", 250);
	if (wakeup_reason() == "recon_target_open")
		break;
}

portrait_text("Notice that the cursor changes to a green targeting reticle. However, if you move the view a large distance away then the cursor reverts to the normal blue pointer. This means the current mouse position is outside of the selected ships' fuel range. The dividing line between the area of space that is within range and that which is not is marked by a circular blue line.", "notice_that_cursor.ogg");
wait_for_portrait();

while (true) {
	portrait_text("Now, whilst holding down the shift key, right click to place a few waypoints in the area where the enemy convoy is believed to be.", "now_whilst.ogg");
	wait_for_task("recon_launched", 250);
	if (wakeup_reason() == "recon_launched")
		break;
}

set_portrait("Tutorial");
portrait_text("Once your ships have visited each waypoint they will return home to their hangar. Whilst in their hangar small ships will refuel. Torpedo bombers will also rearm with torpedos if neccessary.", "once_your.ogg");
wait_for_portrait();

wait_for_task("freighter_found", -1);

set_portrait("Morellian Fighter Pilot");
portrait_text("We've found the enemy convoy!", "weve_found.ogg");
wait_for_portrait();

set_portrait("Tutorial");
while (true) {
	portrait_text("Now we are certain where the enemy convoy is, we must destroy it. Bring up the missions menu again, select all of your torpedo bomber squadrons, and then click the \"Attack mission\" icon. Then right click in space near the enemy convoy to launch the attack mission.", "now_we.ogg");
	wait_for_task("attack_bomber_launched", 250);
	if (wakeup_reason() == "attack_bomber_launched")
		break;
}

portrait_text("On this mission, your bombers do not really require an escort, because the enemy does not have any fighters to defend with. However, note that it is possible to include both bombers and fighters together on an attack mission. If you do this the fighters will automatically defend the bombers from enemy fighter patrols.", "on_this_mission.ogg");

wait_for_task("enemy_under_attack", -1);
set_portrait("Freighter Captain");
portrait_text("We're under attack! Help! Please, requesting aid from any ships in range!", "were_under.ogg");
wait_for_portrait();

set_portrait("Moravator Captain");
portrait_text("Unfortunately for him there are no other ships for several parsecs in any direction.", "unfort.ogg");
wait_for_portrait();

wait_for_task("all_big_ships_dead", -1);
mission_complete();

wait(120);

portrait_text("Excellent work, Admiral. The battle is won, and the Artilian Empire's war effort has been set back months.", "excellent.ogg");
wait_for_portrait();

portrait_text("But the war is far from over - I'm sure your tactical abilities will be put to the test again soon enough.", "but_the.ogg");
wait_for_portrait();

wait(150);
end_mission();


